/*
 * Decompiled with CFR 0.152.
 */
package projectvibrantjourneys.init.world;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import projectvibrantjourneys.common.world.features.FallenTreeFeature;
import projectvibrantjourneys.core.PVJConfig;
import projectvibrantjourneys.init.world.PVJBiomes;
import projectvibrantjourneys.init.world.PVJConfiguredFeatures;

@Mod.EventBusSubscriber(modid="projectvibrantjourneys")
public class PVJWorldGen {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void addBiomeFeatures(BiomeLoadingEvent event) {
        RegistryKey biome = RegistryKey.func_240903_a_((RegistryKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)event.getName());
        Set biomeTypes = BiomeDictionary.getTypes((RegistryKey)biome);
        List vegetalFeatures = event.getGeneration().getFeatures(GenerationStage.Decoration.VEGETAL_DECORATION);
        if (!((List)PVJConfig.groundcoverBlacklist.get()).contains(event.getName().toString())) {
            if (event.getCategory() == Biome.Category.NETHER) {
                if (((Boolean)PVJConfig.charredBones.get()).booleanValue()) {
                    event.getGeneration().getFeatures(GenerationStage.Decoration.UNDERGROUND_DECORATION).add(() -> PVJConfiguredFeatures.charred_bones);
                }
            } else if (PVJWorldGen.hasType(biomeTypes, BiomeDictionary.Type.OVERWORLD)) {
                if (PVJWorldGen.hasType(biomeTypes, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.PLAINS)) {
                    if (((Boolean)PVJConfig.twigs.get()).booleanValue()) {
                        vegetalFeatures.add(() -> PVJConfiguredFeatures.twigs);
                    }
                    if (((Boolean)PVJConfig.fallenLeaves.get()).booleanValue()) {
                        vegetalFeatures.add(() -> PVJConfiguredFeatures.fallen_leaves);
                    }
                }
                if (PVJWorldGen.hasType(biomeTypes, BiomeDictionary.Type.CONIFEROUS) && ((Boolean)PVJConfig.pinecones.get()).booleanValue()) {
                    vegetalFeatures.add(() -> PVJConfiguredFeatures.pinecones);
                }
                if (PVJWorldGen.hasType(biomeTypes, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.BEACH) && ((Boolean)PVJConfig.seashells.get()).booleanValue()) {
                    vegetalFeatures.add(() -> PVJConfiguredFeatures.seashells);
                    vegetalFeatures.add(() -> PVJConfiguredFeatures.ocean_seashells);
                }
                if (!PVJWorldGen.hasType(biomeTypes, BiomeDictionary.Type.MUSHROOM) && ((Boolean)PVJConfig.rocks.get()).booleanValue()) {
                    vegetalFeatures.add(() -> PVJConfiguredFeatures.rocks);
                }
                if (!PVJWorldGen.hasType(biomeTypes, BiomeDictionary.Type.MUSHROOM) && ((Boolean)PVJConfig.bones.get()).booleanValue()) {
                    vegetalFeatures.add(() -> PVJConfiguredFeatures.bones);
                }
                if (PVJWorldGen.hasType(biomeTypes, BiomeDictionary.Type.SNOWY) && ((Boolean)PVJConfig.iceChunks.get()).booleanValue()) {
                    vegetalFeatures.add(() -> PVJConfiguredFeatures.ice_chunks);
                }
            }
        }
        if (event.getCategory() == Biome.Category.NETHER) {
            if (((Boolean)PVJConfig.glowcap.get()).booleanValue()) {
                event.getGeneration().getFeatures(GenerationStage.Decoration.UNDERGROUND_DECORATION).add(() -> PVJConfiguredFeatures.glowcap);
            }
            if (biome == Biomes.field_235254_j_ || biome == Biomes.field_235253_az_ || biome == Biomes.field_235250_aA_) {
                event.getGeneration().getFeatures(GenerationStage.Decoration.UNDERGROUND_DECORATION).add(() -> PVJConfiguredFeatures.cindercane);
            }
            if (((Boolean)PVJConfig.netherNettles.get()).booleanValue()) {
                if (biome == Biomes.field_235253_az_) {
                    event.getGeneration().getFeatures(GenerationStage.Decoration.UNDERGROUND_DECORATION).add(() -> PVJConfiguredFeatures.crimson_nettle);
                }
                if (biome == Biomes.field_235250_aA_) {
                    event.getGeneration().getFeatures(GenerationStage.Decoration.UNDERGROUND_DECORATION).add(() -> PVJConfiguredFeatures.warped_nettle);
                }
            }
        } else if (PVJWorldGen.hasType(biomeTypes, BiomeDictionary.Type.OVERWORLD) && event.getCategory() != Biome.Category.THEEND && event.getCategory() != Biome.Category.MUSHROOM) {
            if (PVJWorldGen.hasType(biomeTypes, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.BEACH) && !PVJWorldGen.hasType(biomeTypes, BiomeDictionary.Type.SNOWY) && ((Boolean)PVJConfig.seaOats.get()).booleanValue()) {
                vegetalFeatures.add(() -> PVJConfiguredFeatures.sea_oats);
            }
            if (!PVJWorldGen.hasType(biomeTypes, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.BEACH) && event.getCategory() != Biome.Category.DESERT && ((Boolean)PVJConfig.cattails.get()).booleanValue()) {
                vegetalFeatures.add(() -> PVJConfiguredFeatures.cattails);
                vegetalFeatures.add(() -> PVJConfiguredFeatures.water_cattails);
            }
            if (PVJWorldGen.hasType(biomeTypes, BiomeDictionary.Type.PLAINS) && ((Boolean)PVJConfig.bushes.get()).booleanValue()) {
                vegetalFeatures.add(() -> PVJConfiguredFeatures.bushes);
            }
            if (((Boolean)PVJConfig.barkMushrooms.get()).booleanValue()) {
                vegetalFeatures.add(() -> PVJConfiguredFeatures.bark_mushrooms);
            }
            if (((Boolean)PVJConfig.shortGrass.get()).booleanValue() && !((List)PVJConfig.groundcoverBlacklist.get()).contains(event.getName().toString())) {
                vegetalFeatures.add(() -> PVJConfiguredFeatures.short_grass);
            }
            if (PVJWorldGen.hasType(biomeTypes, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.BEACH) && !PVJWorldGen.hasType(biomeTypes, BiomeDictionary.Type.SNOWY) && ((Boolean)PVJConfig.beachGrass.get()).booleanValue()) {
                vegetalFeatures.add(() -> PVJConfiguredFeatures.beach_grass);
            }
            if (((Boolean)PVJConfig.cobwebs.get()).booleanValue()) {
                vegetalFeatures.add(() -> PVJConfiguredFeatures.cobwebs);
            }
            if (event.getCategory() != Biome.Category.DESERT && event.getCategory() != Biome.Category.MESA && event.getCategory() != Biome.Category.RIVER && event.getCategory() != Biome.Category.OCEAN && ((Boolean)PVJConfig.moreSeagrass.get()).booleanValue()) {
                vegetalFeatures.add(() -> Features.field_243963_w);
            }
            if (event.getCategory() == Biome.Category.RIVER && ((Boolean)PVJConfig.moreGrassInRivers.get()).booleanValue()) {
                vegetalFeatures.add(() -> Features.field_243848_au);
            }
            if (biome == PVJBiomes.Keys.OVERGROWN_SPIRES) {
                vegetalFeatures.add(() -> PVJConfiguredFeatures.overgrown_spires_vegetation);
            } else if (biome == PVJBiomes.Keys.REDWOODS || biome == PVJBiomes.Keys.REDWOOD_PEAKS || biome == PVJBiomes.Keys.SNOWY_REDWOODS) {
                vegetalFeatures.add(() -> PVJConfiguredFeatures.redwood_forest_vegetation);
            } else if (biome == PVJBiomes.Keys.BOREAL_FOREST || biome == PVJBiomes.Keys.SNOWY_BOREAL_FOREST || biome == PVJBiomes.Keys.ALPINE_HEIGHTS) {
                vegetalFeatures.add(() -> PVJConfiguredFeatures.boreal_forest_vegetation);
            } else if (biome == PVJBiomes.Keys.PINE_MEADOWS) {
                vegetalFeatures.add(() -> PVJConfiguredFeatures.pine_meadows_vegetation);
            } else if (biome == PVJBiomes.Keys.VERDANT_SANDS) {
                vegetalFeatures.add(() -> PVJConfiguredFeatures.beach_grass);
                vegetalFeatures.add(() -> PVJConfiguredFeatures.cattails);
            } else if (biome == PVJBiomes.Keys.BOREAL_PLATEAU) {
                vegetalFeatures.add(() -> PVJConfiguredFeatures.boreal_plateau_vegetation);
            } else if (biome == PVJBiomes.Keys.ASPEN_GROVE || biome == PVJBiomes.Keys.ASPEN_GROVE_HILLS) {
                vegetalFeatures.add(() -> PVJConfiguredFeatures.aspen_grove_vegetation);
                vegetalFeatures.add(() -> PVJConfiguredFeatures.autumn_floor_foliage);
            } else if (biome == PVJBiomes.Keys.MANGROVE_MARSH) {
                vegetalFeatures.add(() -> PVJConfiguredFeatures.mangrove_marsh_vegetation);
                vegetalFeatures.add(() -> PVJConfiguredFeatures.marsh_tall_grass);
            } else if (biome == PVJBiomes.Keys.WILLOW_WETLANDS) {
                vegetalFeatures.add(() -> PVJConfiguredFeatures.willow_wetlands_vegetation);
            } else if (biome == PVJBiomes.Keys.BAOBAB_FIELDS) {
                vegetalFeatures.add(() -> PVJConfiguredFeatures.baobab_fields_vegetation);
            } else if (biome == PVJBiomes.Keys.PRAIRIE) {
                vegetalFeatures.add(() -> PVJConfiguredFeatures.prairie_grass);
                vegetalFeatures.add(() -> PVJConfiguredFeatures.prairie_vegetation);
            } else if (biome == PVJBiomes.Keys.BLOSSOMING_FIELDS) {
                vegetalFeatures.add(() -> PVJConfiguredFeatures.blossoming_fields_vegetation);
                vegetalFeatures.add(() -> PVJConfiguredFeatures.sakura_floor_foliage);
            } else if (biome == PVJBiomes.Keys.AUTUMNAL_CONIFEROUS_FOREST) {
                vegetalFeatures.add(() -> PVJConfiguredFeatures.autumnnal_coniferous_forest_vegetation);
            } else if (biome == PVJBiomes.Keys.CRIMSON_THICKET) {
                vegetalFeatures.add(() -> PVJConfiguredFeatures.crimson_thicket_vegetation);
                vegetalFeatures.add(() -> PVJConfiguredFeatures.crimson_thicket_floor_foliage);
            } else if (biome == PVJBiomes.Keys.DESERT_SHRUBLAND) {
                vegetalFeatures.add(() -> PVJConfiguredFeatures.desert_shrubland_vegetation);
                event.getGeneration().getFeatures(GenerationStage.Decoration.LOCAL_MODIFICATIONS).add(() -> PVJConfiguredFeatures.desert_rock);
                vegetalFeatures.add(() -> PVJConfiguredFeatures.dry_grass);
                vegetalFeatures.add(() -> PVJConfiguredFeatures.desert_sage);
                vegetalFeatures.add(() -> PVJConfiguredFeatures.blooming_desert_agave);
                vegetalFeatures.add(() -> PVJConfiguredFeatures.desert_agave);
            } else if (biome == PVJBiomes.Keys.RED_ROCK_VALLEY_BIOME) {
                vegetalFeatures.add(() -> PVJConfiguredFeatures.desert_shrubland_vegetation);
                vegetalFeatures.add(() -> PVJConfiguredFeatures.blooming_desert_agave);
                vegetalFeatures.add(() -> PVJConfiguredFeatures.desert_agave);
                vegetalFeatures.add(() -> PVJConfiguredFeatures.vanilla_juniper);
            } else if (biome == PVJBiomes.Keys.TROPICAL_BEACH) {
                vegetalFeatures.add(() -> PVJConfiguredFeatures.tropical_beach_vegetation);
            } else if (biome == PVJBiomes.Keys.CRYSTAL_LAKES) {
                vegetalFeatures.add(() -> PVJConfiguredFeatures.crystal_lakes_vegetation);
            } else if (biome == PVJBiomes.Keys.WINDSWEPT_CLIFFS) {
                vegetalFeatures.add(() -> PVJConfiguredFeatures.windswept_cliffs_vegetation);
                vegetalFeatures.add(() -> PVJConfiguredFeatures.cliff_rocks);
            }
            if (((Boolean)PVJConfig.enableJuniperTrees.get()).booleanValue() && (biome == Biomes.field_150589_Z || biome == Biomes.field_150608_ab || biome == Biomes.field_185437_ai || biome == Biomes.field_185439_ak)) {
                vegetalFeatures.add(() -> PVJConfiguredFeatures.vanilla_juniper);
            }
            if (((Boolean)PVJConfig.enablePalmTrees.get()).booleanValue() && (biome == Biomes.field_76787_r || biome == Biomes.field_76782_w || biome == Biomes.field_76792_x || biome == Biomes.field_185446_X)) {
                vegetalFeatures.add(() -> PVJConfiguredFeatures.vanilla_palm);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void addFallenTreeFeatures(BiomeLoadingEvent event) {
        if (!((Boolean)PVJConfig.fallenTrees.get()).booleanValue()) {
            return;
        }
        try {
            List features = event.getGeneration().getFeatures(GenerationStage.Decoration.VEGETAL_DECORATION);
            RegistryKey biome = RegistryKey.func_240903_a_((RegistryKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)event.getName());
            Set biomeTypes = BiomeDictionary.getTypes((RegistryKey)biome);
            ArrayList trees = new ArrayList();
            for (Supplier cf : features) {
                PVJWorldGen.getFeatureNames((ConfiguredFeature)cf.get(), trees);
            }
            Random rand = new Random();
            for (ConfiguredFeature configuredFeature : trees) {
                if (!(configuredFeature.func_242767_c() instanceof BaseTreeFeatureConfig)) continue;
                try {
                    Block block = ((BaseTreeFeatureConfig)configuredFeature.func_242767_c()).field_227368_m_.func_225574_a_(rand, null).func_177230_c();
                    if (!(block instanceof RotatedPillarBlock)) continue;
                    FallenTreeFeature.LOGS.add((Pair<String, Block>)new Pair((Object)event.getName().toString(), (Object)block));
                }
                catch (Exception exception) {}
            }
            if (trees.size() > 0) {
                features.add(() -> PVJConfiguredFeatures.fallen_tree);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getFeatureNames(ConfiguredFeature<?, ?> cf, List<ConfiguredFeature<?, ?>> list) {
        if (Feature.field_202292_al.getRegistryName().equals((Object)cf.func_242766_b().getRegistryName())) {
            ((MultipleRandomFeatureConfig)cf.func_242767_c()).field_202449_a.forEach(s -> list.add((ConfiguredFeature<?, ?>)s.field_214842_a.get()));
        } else if (cf.func_242767_c() instanceof DecoratedFeatureConfig) {
            ConfiguredFeature feature = (ConfiguredFeature)((DecoratedFeatureConfig)cf.func_242767_c()).field_214689_a.get();
            if (feature.func_242767_c() instanceof BaseTreeFeatureConfig) {
                list.add(feature);
            } else {
                return PVJWorldGen.getFeatureNames(feature, list);
            }
        }
        return cf.func_242766_b().getRegistryName().toString();
    }

    private static boolean hasType(Set<BiomeDictionary.Type> list, BiomeDictionary.Type ... types) {
        for (BiomeDictionary.Type t : types) {
            if (!list.contains(t)) continue;
            return true;
        }
        return false;
    }
}

